/*
  cFileIO.c
  John Sterling

  Experimenting with C I/O
  
 */

#include <stdio.h>
#include <stdlib.h>

int main(void) {
    // Create a new file
    FILE* fp = fopen("data", "w");
    // output the string.  Note fputs does not add its own newline
    fputs("Hello world\n", fp);
    // A little formatted output.  The %10d reserves a field 10
    // characters wide and right justifies
    fprintf(fp, "pi = %f; answer = %10d\n", 3.14159265, 42);
    fclose(fp);

    // Reopening and writing to the file shows that the file is truncated
    fp = fopen("data", "w");
    fputs("Happy\n", fp);
    fclose(fp);

    // Reopening but opening with r+ shows that the file is not truncate
    fp = fopen("data", "r+");
    fputs("Bi", fp);
    fclose(fp);

    FILE* jabber = fopen("jabberwocky", "r");
    char buffer[100];
    char* result;
  
    while ( (result = fgets(buffer, 100, jabber)) != NULL) {
        fputs(buffer, stdout);
    }

    //  fclose(jabber);
    fseek(jabber, 0, SEEK_SET);
    int c;
    while ( (c = fgetc(jabber)) != EOF) {
        fputc(c, stdout);
        if (c != '\n') fputc(' ', stdout);
    }

    fclose(jabber);
}
